/*!
 * Neotwi
 * http://www.neo.co.jp/
 * Copyright (C) NEOJAPAN Inc. All Rights Reserved.
 * 本製品は日本国著作権法および国際条約により保護されています。 
 * 本製品の全部または一部を無断で複製したり、無断で複製物を頒 
 * 布すると著作権の侵害となりますのでご注意ください。 
 */
/* global ntwicli */
/* eslint no-undef: "error" */

'use strict';

/**
 * Resource namespace
 * @namespace ntwicli.Resource
 */

if (ntwicli) {
  ntwicli.Resource = ntwicli.Resource ? ntwicli.Resource : {};
} else {
  throw 'Need common library.';
}

/**
 * 共通
 */
ntwicli.Resource.common = {
  'app_name': 'desknet\'s NEO',
  'URL_ONLINE_MANUAL': 'https://www.desknets.com/neo/help/client-tool/index.html',
  'open_source_license': 'オープンソースライセンス情報',
  'online': 'オンライン',
  'offline': 'オフライン',
  'offline_description': '現在オフライン中です'
};

ntwicli.Resource.menu = {
  'Preferences': '設定',
  'Edit': '編集',
  'Quit': '終了',
  'View': '表示',
  'Help': 'ヘルプ',
  'Settings': '接続先設定',
  'ProxyServer': 'プロキシサーバー設定',
  'Question': '広告設定',
  'Undo': '取り消す',
  'Redo': 'やり直す',
  'Cut': '切り取り',
  'Copy': 'コピー',
  'Paste': '貼り付け',
  'Select_All': 'すべてを選択',
  'Reload': '再表示',
  'ToggleFullScreen': '全画面表示',
  'onlineManual': 'オンラインマニュアル',
  'ViewLicense': 'ライセンス',
  'AboutDNEO': ntwicli.Resource.common.app_name.toString() + ' クライアントツール  について',
  'chackNew': '新着チェック',
  'logout': 'ログアウト'
};

/**
 日時関連
 from neo.lang.xx_XX.js.resource.jsから不足分をコピー
 */
ntwicli.Resource.date = {
  'longDateFormat': 'E MM/dd/yyyy',
  'dateTimeFormatWithSecond': 'MM/dd/yyyy h:mm:ss a'
};

/**
 * Utils
 */
ntwicli.Resource.utils = {
  'dialog_title_info': 'Info',
  'dialog_title_warning': 'Warning',
  'dialog_title_error': 'Error'
};

/**
 * ログイン
 */
ntwicli.Resource.login = {
  'login': 'Login',
  'to_setting': '接続先を設定する',
  'login_url_required': '接続先URLを設定してください。',
  'login_url_required_detail': '接続先設定画面で接続先URLを設定してください。',
  'login_loginid_required': 'ログインIDを設定してください。',
  'login_loginid_required_detail': '接続先設定画面でログインIDを設定してください。',
  'login_auth_401_msg': '基本認証が必要',
  'login_auth_401_detail': '接続先には基本認証が設定されています。接続先設定画面で正しい基本認証情報を設定してください。',
  'login_verchk_404_detail': '接続先モジュールが確認できません。desknet\'s NEOの設定をご確認ください。',
  'login_failed_windows_integrated_auth': "desknet's NEOにログインできませんでした。" // BTMANTIS0051353
};

/**
 * ネオツイ
 */
ntwicli.Resource.ntwi = {
  // タブ
  'notice': 'Announce',
  'tweet': 'Tweets',
  'dm': 'DM',
  'readByMeLabel': 'Read',
  'readByYouLabel': 'Opened',
  'post': 'Post', // BTMANTIS0031739
  'send': 'Send', // BTMANTIS0031739
  'remove': 'Remove', // BTMANTIS0031739
  'reply': 'Reply', // BTMANTIS0031739
  'delete': 'Delete', // BTMANTIS0031845
  'editorOpen': 'Open', // BTMANTIS0031845
  'editorClose': 'Close', // BTMANTIS0031845
  'back': 'Back', // BTMANTIS0031739
  'attachment': 'Attachment File', // BTMANTIS0031739
  'stamp': 'Stamp', // BTMANTIS0031739
  'emoticon': 'Emoticon', // BTMANTIS0031740
  'history': 'History', // BTMANTIS0031740
  'previous': 'Previous', // BTMANTIS0031740
  'next': 'Next', // BTMANTIS0031740
  'choose_user': 'Choose Recipient', // BTMANTIS0031740

  // データ無しの表示
  'no_data': 'There are no applicable data.',

  // お知らせ
  'ntwi_new_item_memo': '{{detail}}',
  'ntwi_new_item_todo': 'Deadline of "{{detail}}" is coming closer.',
  'ntwi_new_item_todo_end': '"{{detail}}" is overdue.',
  'ntwi_new_item_mail': 'A new message has been received.',
  'ntwi_new_item_creport': '"{{detail}}" has arrived.',
  'ntwi_new_item_creport_watchlist': 'You received a comment in the Watchlist "{{detail}}".', // NVPV85R10_0083670
  'ntwi_new_item_flow': '"{{detail}}" has arrived.',
  'ntwi_new_item_enq': '"{{detail}}" has arrived.',
  'ntwi_new_item_forum': 'A new message has been posted to "{{detail}}".',
  'ntwi_new_item_safety': '{{detail}}',
  'ntwi_new_item_info': '{{detail}}',
  'ntwi_new_item_info_approval': '{{detail}}',
  'ntwi_new_item_catalog_amazon': '{{detail}}', // V5.3 BTMANTIS0053779 Amazonビジネス連携
  'ntwi_new_item_catalog_amazon_approval_request': '"{{detail}}" has arrived.', // V5.3 BTMANTIS0053779 Amazonビジネス連携
  'ntwi_chatluck_title': 'ChatLuck',

  'andNItemsLabel': 'Other {{count}} item(s)',
  'toDoItemsLabel': 'Today {{count}} item(s)',
  'toDoExpiredLabel': '{{othercnt}} overdue item(s)'
};

/**
 * 設定画面
 */
ntwicli.Resource.set = {
  'title': '接続先設定',
  'url': '接続先URL',
  'login': 'ログイン',
  'login_id': 'ログイン ID',
  'password': 'パスワード',
  'basic_auth_announcement': '※接続先URLに認証が設定されている場合、以下の情報を入力してください。',
  'basic_auth_input': 'Webサーバーの基本認証を行う。',
  'windows_integrated_auth_input': '統合Windows認証を行う。', // BTMANTIS0051353
  'basic_auth': '基本認証',
  'basic_user': 'ユーザー名',
  'basic_password': 'パスワード',

  'dialog_info': '確認',
  'dialog_message': '変更した内容は再度ログインするまで適用されません。今すぐログアウトしますか？',
  'just_now': '今すぐ',
  'later': '後で',
  'empty_url': 'URLは必須です。',
  'empty_login_id': 'ログインIDは必須です。'
};

/**
 * プロキシサーバー設定
 */
ntwicli.Resource.proxy = {
  'title': 'プロキシサーバー設定',
  'proxy_server_guidance': '※desknet\'s NEOへのアクセスにプロキシサーバーを使用する場合、プロキシサーバー情報を設定してください。',
  'use_proxy_server': 'プロキシサーバーを使用する。',
  'proxy_host': 'ホスト名またはIPアドレス',
  'proxy_port': 'ポート番号',
  'proxy_authentication_guidance': '※プロキシサーバーに認証が設定されている場合、以下の情報を入力してください。',
  'basic_auth': '認証情報',
  'proxy_auth_input': 'プロキシサーバーの認証を行う。',
  'proxy_auth_user': 'ユーザー名',
  'proxy_auth_word': 'パスワード',
  'dialog_message': '設定はアプリケーションを再起動するまで反映されません。アプリケーションを再起動してください。',

  'empty_host': 'ホスト名またはIPアドレスは必須です。',
  'empty_port': 'ポート番号は必須です。',
  'invalid_port': 'ポート番号が不正です。0-65535の数値を入力してください。'
};

/**
 * 広告設定
 */
ntwicli.Resource.question = {
  'title': '広告設定',
  'question_guidance': '　*ご入力いただいた属性情報は次の目的のために利用させていただきます。',
  'question_guidance_1': '・通知・広告表示内容の最適化',
  'question_guidance_2': '・ネオジャパンのサービスおよび製品開発のための統計データ作成',
  'question_legend': '属性',
  'question_gender': '性別',
  'question_non': '未選択',
  'question_male': '男性',
  'question_female': '女性',
  'question_age': '年代',
  'question_age_select': {
    '0': '未選択',
    '10': '10代',
    '20': '20代',
    '30': '30代',
    '40': '40代',
    '50': '50代',
    '60': '60代',
    '70': '70代以上'
  },
  'question_prefecture': 'お住まい',
  'question_prefecture_select': {
    '0': '未選択',
    '1': '北海道',
    '2': '青森県',
    '3': '岩手県',
    '4': '宮城県',
    '5': '秋田県',
    '6': '山形県',
    '7': '福島県',
    '8': '茨城県',
    '9': '栃木県',
    '10': '群馬県',
    '11': '埼玉県',
    '12': '千葉県',
    '13': '東京都',
    '14': '神奈川県',
    '15': '新潟県',
    '16': '富山県',
    '17': '石川県',
    '18': '福井県',
    '19': '山梨県',
    '20': '長野県',
    '21': '岐阜県',
    '22': '静岡県',
    '23': '愛知県',
    '24': '三重県',
    '25': '滋賀県',
    '26': '京都府',
    '27': '大阪府',
    '28': '兵庫県',
    '29': '奈良県',
    '30': '和歌山県',
    '31': '鳥取県',
    '32': '島根県',
    '33': '岡山県',
    '34': '広島県',
    '35': '山口県',
    '36': '徳島県',
    '37': '香川県',
    '38': '愛媛県',
    '39': '高知県',
    '40': '福岡県',
    '41': '佐賀県',
    '42': '長崎県',
    '43': '熊本県',
    '44': '大分県',
    '45': '宮崎県',
    '46': '鹿児島県',
    '47': '沖縄県',
    '-1': '外国'
  },
  'question_check_allow': '属性情報の提供に同意します。',
  'client_id': 'クライアントID'
};